---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
---

# Brittleness (diagnostic)

> Small perturbations cause fragmentation or collapse; stability margins are insufficient.

---

## Definition

- Easy break tendency
- Fragile structure state
- Low shock tolerance
- Quick failure pattern

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Break ease | Fail quick | `Monitor`, `Break` |
| Fragility | Weak point | `Check`, `Weak` |
| Low margin | Thin buffer | `Test`, `Thin` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Break ease | Snaps fast | "Breaks easy" |
| Fragility | Delicate part | "Too fragile" |
| Low margin | No cushion | "No give" |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| Fail quick | Snaps fast | How breaks work |
| Weak point | Delicate part | How fragility forms |
| Thin buffer | No cushion | How margin fails |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | Break point | Force snap |
| Networks | Link break | Chain snap |
| Cognition | Pattern break | Mind snap |
| Systems | State break | Flow snap |

---

## Scale Effects

How Brittleness manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Quantum break | Wave snap |
| λV | Gate fail | State break |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Phase break | Pattern snap |
| ∇S | Structure fail | Clear break |

### Cosmic Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Wave break | Light snap |
| λV | Field fail | Space break |

Note: At extreme scales, brittleness faces fundamental limits (e.g., quantum breaks at ε, causal snaps at c).

---

## Invariants / Thresholds

Scale-dependent bounds:
- ε: break threshold
- c: snap limit
- ψA: phase margin
- λV: gate strength

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | Pattern break | Wave snap |
| Human | λV | Gate fail | Flow break |
| Cosmic | ψA | Phase snap | Field fail |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | Quick break | Pattern snap | Too fast |
| Human | Chain fail | Link break | All falls |
| Cosmic | Field snap | Structure break | Total fail |

---

## Diagnostic Checklist

Technical tests:
- [ ] Break point found
- [ ] Weak spots mapped
- [ ] Margins thin
- [ ] Chain risks seen

Humane tests:
- [ ] Snaps noted
- [ ] Fragile parts found
- [ ] No give felt
- [ ] Chain risks clear

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical brittleness nor experiential fragility alone captures its full meaning.

---

## See Also

- [[Stability Margin (diagnostic)]]
- [[Robustness (diagnostic)]]
- [[Resilience (diagnostic)]]
- [[Form]]
- [[Field]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented